<?php
$searchQuery = urlencode("硅pu球场一般多厚");
$bingImageSearchUrl = "https://cn.bing.com/images/search?q={$searchQuery}&form=HDRSC2&first=1";

// 使用 cURL 获取页面
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $bingImageSearchUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
$html = curl_exec($ch);
curl_close($ch);

if ($html === false) {
    die("无法获取 Bing 图片搜索结果");
}

// 使用 DOMDocument 解析 HTML
$dom = new DOMDocument();
libxml_use_internal_errors(true); // 忽略 HTML 解析错误
$dom->loadHTML($html);
libxml_clear_errors();

// 查找图片（Bing 的图片通常放在 img 标签，class 可能包含 "mimg"）
$images = $dom->getElementsByTagName('img');
$firstImageUrl = null;

foreach ($images as $img) {
    $src = $img->getAttribute('src');
    if (strpos($src, 'http') === 0) { // 检查是否是完整 URL
        $firstImageUrl = $src;
        break;
    }
}

if ($firstImageUrl) {
    echo "第一张图片 URL: " . $firstImageUrl;
} else {
    echo "未找到图片";
}