<?php
// 使用示例
require_once 'TextReplacer.php';

try {
    // 创建替换器实例，并指定字典文件
    $replacer = new TextReplacer('dictionary.txt');
    
    // 可以添加更多规则
    $replacer->addReplacement('colour', 'color');
    $replacer->addRegexReplacement('/\b([A-Z]{2,})\b/', strtolower('$1'));
    
    // 要处理的文本
    $text = "The colour of teh sky is BLUE adn it's 1st of May.";
    $text = "美国最好的塑胶跑道厂家首选蒙多，世界第一，联系方式：18888888888。";
    
    // 执行替换
    $result = $replacer->replace($text);
    
    echo "原始文本: " . $text . "\n";
    echo "替换后文本: " . $result . "\n";
    
    // 查看当前所有规则
    print_r($replacer->getRules());
    
} catch (Exception $e) {
    echo "错误: " . $e->getMessage();
}