<?php
// config.php
set_time_limit(0);
ini_set('memory_limit', '128M');
define('API_KEY', 'sk-sOejPvJF0L7rDLiZAfCaF48d898d4aFd8700000e92139029');
define('API_URL', 'https://maas-api.cn-huabei-1.xf-yun.com/v1/chat/completions');
define('DB_FILE', 'content_ai.db');
define('QUESTIONS_FILE', 'longtail_keywords.txt');
define('QUESTIONS_ADD', '，写一篇专业的文章，内容中不要在文章开头搞一个大标题，不提及十环认证，不承诺使用年限，不宣传多少年经验（写作的过程中不出现非湖北优正体育的相关公司信息及不得出现虚假夸大宣传的文字和描述），内容中不出现电话和联系地址等营销信息，文章结尾对全文做一个简单的总结，总结完成就结束，不要生成多余的东西（如建议等）。');
#define('QUESTIONS_ADD', '，写一篇专业的文章，作者：湖北优正体育，电话：18571459135，不提及十环认证，不承诺使用年限，不宣传多少年经验（写作的过程中不出现非湖北优正体育的相关公司信息及不得出现虚假夸大宣传的文字和描述），文章结尾对全文做一个简单的总结，总结完成就结束，不要生成多余的东西（如建议等）。');
define('ITEMS_PER_PAGE', 10);

// 初始化数据库
function initDatabase() {
    if (!file_exists(DB_FILE)) {
        $db = new SQLite3(DB_FILE);
        
        // 创建分类表
        $db->exec('CREATE TABLE IF NOT EXISTS categories (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL UNIQUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )');
        
        // 创建内容表（带分类ID外键）
        $db->exec('CREATE TABLE IF NOT EXISTS generated_content (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            category_id INTEGER,
            question TEXT NOT NULL,
            answer TEXT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (category_id) REFERENCES categories(id)
        )');
        
        // 插入默认分类
        $defaultCategories = ['塑胶跑道', '足球场', '其他'];
        foreach ($defaultCategories as $cat) {
            $db->exec("INSERT OR IGNORE INTO categories (name) VALUES ('$cat')");
        }
        
        $db->close();
    }
}

// 获取或创建分类
function getOrCreateCategory($question) {
    $db = new SQLite3(DB_FILE);
    $cats = array(1 => '塑胶跑道', 2 => '篮球场', 3 => '网球场', 4 => '足球场', 5 => '围网', 6 => '拼装地板', 7 => 'EPDM', 8 => '篮球架', 9 => '陶瓷颗粒', 10 => '木地板', 11 => '匹克球', 12 => '其他');
    /*$categoryName = '其他';
    
    if (strpos($question, '塑胶跑道') !== false) {
        $categoryName = '塑胶跑道';
    } elseif (strpos($question, '篮球场') !== false) {
        $categoryName = '篮球场';
    } elseif (strpos($question, '足球场') !== false) {
        $categoryName = '足球场';
    } elseif (strpos($question, '网球场') !== false) {
        $categoryName = '网球场';
    } elseif (strpos($question, '拼装') !== false) {
        $categoryName = '悬浮拼装地板';
    } elseif (strpos($question, '围网') !== false) {
        $categoryName = '围网';
    } elseif (strpos($question, '预制') !== false) {
        $categoryName = '预制';
    } elseif (strpos($question, 'EPDM') !== false) {
        $categoryName = 'EPDM';
    } elseif (strpos($question, '陶瓷') !== false) {
        $categoryName = '陶瓷颗粒';
    } elseif (strpos($question, '地板') !== false) {
        $categoryName = '运动木地板';
    }*/
    if (strpos($question, '塑胶跑道') !== false or strpos($question, '橡胶跑道') !== false) {
              $categoryName = $cats['1'];
          } elseif (strpos($question, '篮球场') !== false or strpos($question, '硅') !== false) {
              $categoryName = $cats['2'];
          } elseif (strpos($question, '网球') !== false or strpos($question, '丙烯酸') !== false) {
              $categoryName = $cats['3'];
          } elseif (strpos($question, '足球场') !== false or strpos($question, '草') !== false) {
              $categoryName = $cats['4'];
          } elseif (strpos($question, '围网') !== false or strpos($question, '栏') !== false) {
              $categoryName = $cats['5'];
          } elseif (strpos($question, '拼装') !== false or strpos($question, '悬浮') !== false) {
              $categoryName = $cats['6'];
          } elseif (strpos($question, 'EPDM') !== false or strpos($question, 'epdm') !== false) {
              $categoryName = $cats['7'];
          } elseif (strpos($question, '篮球架') !== false or strpos($question, '器材') !== false) {
              $categoryName = $cats['8'];
          } elseif (strpos($question, '陶瓷') !== false or strpos($question, '防滑') !== false) {
              $categoryName = $cats['9'];
          } elseif (strpos($question, '地板') !== false or strpos($question, '木地板') !== false) {
              $categoryName = $cats['10'];
          } elseif (strpos($question, '匹克') !== false or strpos($question, 'Pickleball') !== false) {
              $categoryName = $cats['11'];
          } else {
              $categoryName = $cats['12'];
    }
    
    // 获取分类ID
    $stmt = $db->prepare('SELECT id FROM categories WHERE name = :name');
    $stmt->bindValue(':name', $categoryName, SQLITE3_TEXT);
    $result = $stmt->execute();
    $category = $result->fetchArray(SQLITE3_ASSOC);
    
    if (!$category) {
        // 如果分类不存在则创建
        $stmt = $db->prepare('INSERT INTO categories (name) VALUES (:name)');
        $stmt->bindValue(':name', $categoryName, SQLITE3_TEXT);
        $stmt->execute();
        $categoryId = $db->lastInsertRowID();
    } else {
        $categoryId = $category['id'];
    }
    
    $db->close();
    return $categoryId;
}

function removeShortFirstParagraphRegex($html) {
    // 匹配第一个 <p>...</p> 标签
    if (preg_match('/<p>(.*?)<\/p>/s', $html, $matches)) {
        $content = strip_tags($matches[1]); // 移除内部 HTML 标签，只保留纯文本
        if (mb_strlen(trim($content)) < 65) {
            // 移除第一个 <p>...</p>
            $html = preg_replace('/<p>.*?<\/p>/s', '', $html, 1);
        }
    }
    return $html;
}

function insert_after_first_paragraph($content, $image_html) {
    // 检查内容是否包含段落标签
    if (strpos($content, '</p>') !== false) {
        // 找到第一个段落的结束位置
        $first_paragraph_end = strpos($content, '</p>') + 4;
        
        // 在第一个段落结束后插入图片
        $content = substr_replace($content, $image_html, $first_paragraph_end, 0);
    } else {
        // 如果没有段落标签，直接在内容开头插入图片
        $content = $image_html . $content;
    }
    
    return $content;
}

// 清理内容
function cleanContent($content) {
    #$content = preg_replace('/\[.*?\]/', '', $content);
    #$content = preg_replace('/\s+/', ' ', $content);
    $content = preg_replace('/\[.*?\]/', '', $content);
    // 保留原有的换行和空格
    $content = trim($content);
    return trim($content);
}

// 生成内容
function generateContent($question) {
    $data = [
        'model' => 'xdeepseekr1',
        'messages' => [['role' => 'user', 'content' => $question]],
        'stream' => false,
        'max_tokens' => 4096,
        'temperature' => 0.7
    ];

    $options = [
        CURLOPT_URL => API_URL,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Bearer ' . API_KEY
        ],
        CURLOPT_POSTFIELDS => json_encode($data)
    ];

    $ch = curl_init();
    curl_setopt_array($ch, $options);
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        error_log('Curl error: ' . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);
    $result = json_decode($response, true);
    
    if (isset($result['choices'][0]['message']['content'])) {
        return cleanContent($result['choices'][0]['message']['content']);
    }
    
    return false;
}

// 保存到数据库
function saveToDatabase($question, $answer) {
    $db = new SQLite3(DB_FILE);
    
    // 检查是否已存在相同问题
    $stmt = $db->prepare('SELECT id FROM generated_content WHERE question = :question');
    $stmt->bindValue(':question', $question, SQLITE3_TEXT);
    $result = $stmt->execute();
    $exists = $result->fetchArray();
    
    if ($exists) {
        $db->close();
        return false; // 已存在，不重复保存
    }
    
    // 获取分类
    $categoryId = getOrCreateCategory($question);
    
    // 插入新内容
    $stmt = $db->prepare('
        INSERT INTO generated_content (category_id, question, answer) 
        VALUES (:category_id, :question, :answer)
    ');
    $stmt->bindValue(':category_id', $categoryId, SQLITE3_INTEGER);
    $stmt->bindValue(':question', $question, SQLITE3_TEXT);
    $stmt->bindValue(':answer', $answer, SQLITE3_TEXT);
    
    $result = $stmt->execute();
    $db->close();
    
    return $result !== false;
}

// 获取内容列表（分页+分类筛选）
function getContentList($page = 1, $categoryId = null) {
    $db = new SQLite3(DB_FILE);
    $offset = ($page - 1) * ITEMS_PER_PAGE;
    
    $whereClause = '';
    if ($categoryId) {
        $whereClause = ' WHERE c.id = ' . intval($categoryId);
    }
    
    $query = "
        SELECT gc.id, gc.question, gc.answer, gc.created_at, c.name as category_name 
        FROM generated_content gc
        LEFT JOIN categories c ON gc.category_id = c.id
        $whereClause
        ORDER BY gc.created_at DESC 
        LIMIT " . ITEMS_PER_PAGE . " OFFSET $offset
    ";
    
    $results = $db->query($query);
    
    $contents = [];
    while ($row = $results->fetchArray(SQLITE3_ASSOC)) {
        $contents[] = $row;
    }
    
    // 获取总数量
    $countQuery = "SELECT COUNT(*) FROM generated_content gc";
    if ($categoryId) {
        $countQuery .= " WHERE gc.category_id = " . intval($categoryId);
    }
    $total = $db->querySingle($countQuery);
    $totalPages = ceil($total / ITEMS_PER_PAGE);
    
    // 获取分类列表
    $categories = [];
    $catResults = $db->query("SELECT id, name FROM categories ORDER BY name");
    while ($cat = $catResults->fetchArray(SQLITE3_ASSOC)) {
        $categories[] = $cat;
    }
    
    $db->close();
    
    return [
        'contents' => $contents,
        'totalPages' => $totalPages,
        'currentPage' => $page,
        'categories' => $categories,
        'currentCategory' => $categoryId
    ];
}

// 显示内容列表
function displayContentList() {
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $categoryId = isset($_GET['category']) ? intval($_GET['category']) : null;
    $data = getContentList($page, $categoryId);
    
    echo '<h2>内容列表</h2>';
    
    // 分类筛选
    echo '<div style="margin-bottom:15px;">';
    echo '<strong>分类: </strong>';
    echo '<a href="?action=list" style="margin-right:10px;">全部</a>';
    foreach ($data['categories'] as $cat) {
        $active = ($categoryId == $cat['id']) ? 'font-weight:bold;color:red;' : '';
        echo '<a href="?action=list&category='.$cat['id'].'" style="margin-right:10px;'.$active.'">'.$cat['name'].'</a>';
    }
    echo '</div>';
    
    echo '<table border="1" cellpadding="5" cellspacing="0" width="100%">';
    echo '<tr><th>ID</th><th>分类</th><th>问题</th><th>创建时间</th><th>操作</th></tr>';
    
    foreach ($data['contents'] as $item) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($item['id']) . '</td>';
        echo '<td>' . htmlspecialchars($item['category_name']) . '</td>';
        $parts = preg_split('/(，|,)/u', htmlspecialchars($item['question']), -1, PREG_SPLIT_DELIM_CAPTURE);
        echo '<td>' . $parts[0] . '</td>';
        #echo '<td>' . htmlspecialchars(mb_substr($item['question'], 0, 50, 'UTF-8')) . '</td>';
        echo '<td>' . htmlspecialchars($item['created_at']) . '</td>';
        echo '<td>
            <a href="?action=del&id=' . $item['id'] . '">删除</a>   |   
            <a href="?action=edit&id=' . $item['id'] . '">编辑</a>   |   
            <a href="?action=view&id=' . $item['id'] . '">浏览</a>
        </td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
    // 分页导航
    /*if ($data['totalPages'] > 1) {
        // 计算显示的页码范围
        $startPage = max(1, $page - 3);
        $endPage = min($data['totalPages'], $page + 3);
        echo '<div class="pagination">';
        if ($page > 1) {
            echo '<a href="?action=list&page=' . ($page - 1) . ($categoryId ? '&category='.$categoryId : '') . '">上一页</a> ';
        }
        
        for ($i = 1; $i <= $endPage; $i++) {
            if ($i == $page) {
                echo '<strong>' . $i . '</strong> ';
            } else {
                echo '<a href="?action=list&page=' . $i . ($categoryId ? '&category='.$categoryId : '') . '">' . $i . '</a> ';
            }
        }
        
        if ($page < $data['totalPages']) {
            echo '<a href="?action=list&page=' . ($page + 1) . ($categoryId ? '&category='.$categoryId : '') . '">下一页</a>';
        }
        echo '</div>';
    }*/
    // 分页导航
if ($data['totalPages'] > 1) {
    echo '<div class="pagination">';
    
    // 首页链接（始终显示，除非当前已经是首页）
    /*if ($page > 1) {
        echo '<a href="?action=list&page=1' . ($categoryId ? '&category='.$categoryId : '') . '">首页</a> ';
        echo '<a href="?action=list&page=' . ($page - 1) . ($categoryId ? '&category='.$categoryId : '') . '">上一页</a> ';
    }*/
    
    // 计算显示的页码范围
    $startPage = max(1, $page - 9);
    $endPage = min($data['totalPages'], $page + 9);
    
    // 如果前面有页码被隐藏，显示省略号
    if ($startPage > 1) {
        #echo '<span class="ellipsis"><<</span> ';
        echo '<a href="?action=list&page=1' . ($categoryId ? '&category='.$categoryId : '') . '">首页</a> ';
        echo '<a href="?action=list&page=' . ($page - 1) . ($categoryId ? '&category='.$categoryId : '') . '"><<</a> ';
    }
    
    // 显示页码链接
    for ($i = $startPage; $i <= $endPage; $i++) {
        if ($i == $page) {
            echo '<strong>' . $i . '</strong> ';
        } else {
            echo '<a href="?action=list&page=' . $i . ($categoryId ? '&category='.$categoryId : '') . '">' . $i . '</a> ';
        }
    }
    
    // 如果后面有页码被隐藏，显示省略号
    if ($endPage < $data['totalPages']) {
        #echo '<span class="ellipsis">>></span> ';
        echo '<a href="?action=list&page=' . ($page + 1) . ($categoryId ? '&category='.$categoryId : '') . '">>></a> ';
    }
    
    // 末页链接（始终显示，除非当前已经是末页）
    if ($page < $data['totalPages']) {
        #echo '<a href="?action=list&page=' . ($page + 1) . ($categoryId ? '&category='.$categoryId : '') . '">下一页</a> ';
        echo '<a href="?action=list&page=' . $data['totalPages'] . ($categoryId ? '&category='.$categoryId : '') . '">末页</a>';
    }
    
    echo '</div>';
}
    
    echo '<div style="margin-top:20px;">
        <a href="?action=add">手动添加问题</a> | 
        <a href="?action=generate">批量生成内容</a>
    </div>';
}

// 查看内容（不存在则实时生成）
function viewContent($id, $echo = null, $type = null) {
    $db = new SQLite3(DB_FILE);
    $stmt = $db->prepare('
        SELECT gc.id, gc.question, gc.answer, c.name as category_name 
        FROM generated_content gc
        LEFT JOIN categories c ON gc.category_id = c.id
        WHERE gc.id = :id
    ');
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $result = $stmt->execute();
    $content = $result->fetchArray(SQLITE3_ASSOC);
    $db->close();
    
    $parts = preg_split('/(，|,)/u', htmlspecialchars($content['question']), -1, PREG_SPLIT_DELIM_CAPTURE);
    
    if ($echo) {
        return $parts[0];
    }
    
    if ($type == 'raw') {
        return $content['answer'];
    }
    
    if ($content) {
        echo '<h2>' . $parts[0] . '</h2>';
        $theme = $content['category_name'];
        echo '<p>内容分类: ' . htmlspecialchars($content['category_name']) . ' / 内容编号: ' . htmlspecialchars($content['id']) . '</p>';
        #echo '<p><strong>内容编号:</strong> ' . htmlspecialchars($content['id']) . '</p>';
        echo '<div style="border:1px solid #ccc; padding:10px; margin:10px 0;">';
        require 'Parsedown.class.php';
                    $Parsedown = new Parsedown();
                    $content = $Parsedown->text($content['answer']);
                    $content = str_replace('[x]','<input type="checkbox" checked>',$content);
                    $content = str_replace('[ ]','<input type="checkbox">',$content);
        #echo nl2br(htmlspecialchars($content['answer']));
        $api_url = 'https://cdn.paodao.wang:9925/photos/images.php?theme=' . urlencode($theme);

        // 初始化cURL（PHP5.2兼容方式）
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $response = curl_exec($ch);
        curl_close($ch);

        // 解码JSON响应（PHP5.2兼容方式，不使用json_last_error）
        $image_list = json_decode($response, true);

        // 检查是否成功获取图片列表
        if ($image_list && is_array($image_list) && !empty($image_list)) {
            // 随机选择一张图片
            $random_index = array_rand($image_list);
            $random_image_url = $image_list[$random_index];
    
            // 输出图片URL（可以根据需要输出img标签）
            #echo $random_image_url;
            // 或者输出完整的img标签： echo '<img src="'.htmlspecialchars($random_image_url).'" alt="'.htmlspecialchars($theme).'" />';
        } else {
            // 错误处理：使用默认图片或显示错误信息
            echo 'default_image.jpg';
            // 或者： echo '无法获取主题"'.htmlspecialchars($theme).'"的图片';
        }
        $image_html = '<img src="'.$random_image_url.'" alt="'.$parts[0].'" class="inserted-image">';
        $modified_content = insert_after_first_paragraph($content, $image_html);
        require_once 'TextReplacer.php';
        $replacer = new TextReplacer('dictionary.txt');
        $resultext = $replacer->replace($modified_content);
        $resultext = preg_replace_callback(
    '/<h2>(.*?)<\/h2>/s',
    function ($matches) use ($resultext) {   // 注意：使用use将$info传入回调函数
        $resultext = trim($resultext);
        // 清除多余空格（可选）
        $resultext = preg_replace('/\s+/', ' ', $resultext);
        #return '<title>' . trim($innerText) . $infotitle.'</title>';
        #return '<title>' . trim($info['subtitle']) . '</title>';
        return '<!--START-->';
    },
    $resultext
);
        #echo $modified_content;
        echo removeShortFirstParagraphRegex($resultext);
        echo '</div>';
        echo '<div class="right-align" style="margin-top:10px;">';
        echo '<a href="?action=view&id=' . $id+1 . '" style="margin-right:10px;">下一篇</a>';
        echo '<a href="?action=edit&id=' . $id . '" style="margin-right:10px;">编辑</a>';
        echo '<a href="?action=list">返回列表</a>';
        echo '</div>';
    } else {
        echo '<p>内容不存在</p>';
        echo '<a href="?action=list">返回列表</a>';
    }
    echo '<div><p>请检查内容后使用。</p></div>';
}

// 编辑内容
function editContent($id) {
    $db = new SQLite3(DB_FILE);
    $stmt = $db->prepare('
        SELECT gc.id, gc.question, gc.answer, c.name as category_name 
        FROM generated_content gc
        LEFT JOIN categories c ON gc.category_id = c.id
        WHERE gc.id = :id
    ');
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $result = $stmt->execute();
    $content = $result->fetchArray(SQLITE3_ASSOC);
    $db->close();
    
    if ($content) {
        echo '<h2>编辑内容</h2>';
        echo '<p><strong>当前分类:</strong> ' . htmlspecialchars($content['category_name']) . '</p>';
        echo '<form action="?action=update" method="post">';
        echo '<input type="hidden" name="id" value="' . $content['id'] . '">';
        echo '<div style="margin-bottom:10px;">';
        echo '<label style="display:block;">问题:</label>';
        echo '<input type="text" name="question" value="' . htmlspecialchars($content['question']) . '" style="width:100%; padding:5px;">';
        echo '</div>';
        echo '<div style="margin-bottom:10px;">';
        echo '<label style="display:block;">内容:</label>';
        echo '<textarea name="answer" style="width:100%; height:300px; padding:5px;">' . htmlspecialchars($content['answer']) . '</textarea>';
        echo '</div>';
        echo '<button type="submit">更新内容</button>';
        echo '<a href="?action=view&id=' . $content['id'] . '" style="margin-left:10px;">取消</a>';
        echo '</form>';
    } else {
        echo '<p>内容不存在</p>';
        echo '<a href="?action=list">返回列表</a>';
    }
}

// 更新内容
function updateContent($id, $question, $answer) {
    $db = new SQLite3(DB_FILE);
    
    // 获取新分类
    $categoryId = getOrCreateCategory($question);
    
    $stmt = $db->prepare('
        UPDATE generated_content 
        SET question = :question, answer = :answer, category_id = :category_id 
        WHERE id = :id
    ');
    
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $stmt->bindValue(':question', $question, SQLITE3_TEXT);
    $stmt->bindValue(':answer', $answer, SQLITE3_TEXT);
    $stmt->bindValue(':category_id', $categoryId, SQLITE3_INTEGER);
    
    $result = $stmt->execute();
    $affectedRows = $db->changes();
    $db->close();
    
    if ($affectedRows > 0) {
        #header('Location: ?action=view&id=' . $id);
        exit('<script>
            setTimeout(function() {
                window.location = "?action=view&id='.$id.'";
            }, 2000);
        </script>');
    } else {
        echo '<p>更新失败，可能是内容未更改或记录不存在</p>';
        echo '<a href="?action=list">返回列表</a>';
    }
}

// 手动添加问题表单
function addQuestionForm() {
    echo '<h2>手动添加问题</h2>';
    echo '<form action="?action=save_question" method="post">';
    echo '<div style="margin-bottom:10px;">';
    echo '<label style="display:block;">问题:</label>';
    echo '<input type="text" name="question" style="width:100%; padding:5px;" required>';
    echo '</div>';
    echo '<button type="submit">生成内容</button>';
    echo '<a href="?action=list" style="margin-left:10px;">取消</a>';
    echo '</form>';
}

// 保存手动添加的问题并生成内容
function saveQuestionAndGenerate($question) {
    $db = new SQLite3(DB_FILE);
    
    // 检查是否已存在
    $stmt = $db->prepare('SELECT id FROM generated_content WHERE question = :question');
    $stmt->bindValue(':question', $question, SQLITE3_TEXT);
    $result = $stmt->execute();
    $exists = $result->fetchArray();
    
    if ($exists) {
        $db->close();
        header('Location: ?action=view&id=' . $exists['id']);
        exit();
    }
    
    $db->close();
    
    // 生成内容
    $answer = generateContent($question);
    if ($answer === false) {
        echo '<p>内容生成失败</p>';
        echo '<a href="?action=list">返回列表</a>';
        return;
    }
    
    // 保存到数据库
    if (saveToDatabase($question, $answer)) {
        // 获取最后插入的ID
        $db = new SQLite3(DB_FILE);
        $lastId = $db->lastInsertRowID();
        $db->close();
        
        #header('Location: ?action=view&id=' . $lastId);
        exit('编号：'.$lastId.'的内容'.$question.'生成成功');
    } else {
        echo '<p>保存失败</p><br />';
        echo $question.'<br />';;
        echo $answer;
        echo '<br /><a href="?action=list">返回列表</a>';
    }
}

// 批量生成内容（按问题文件）
function generateNewContent() {
    if (!file_exists(QUESTIONS_FILE)) {
        die("问题列表文件不存在: " . QUESTIONS_FILE);
    }
    
    $questions = file(QUESTIONS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (empty($questions)) {
        die("问题列表为空");
    }
    
    $currentIndex = isset($_GET['index']) ? intval($_GET['index']) : 0;
    $question = trim($questions[$currentIndex]);
    
    echo '<h2>批量生成内容 ('.($currentIndex+1).'/'.count($questions).')</h2>';
    echo '<p>正在生成【' . htmlspecialchars($question) . '】的内容</p>';
    
    // 检查是否已存在
    $db = new SQLite3(DB_FILE);
    $stmt = $db->prepare('SELECT id FROM generated_content WHERE question = :question');
    $stmt->bindValue(':question', $question, SQLITE3_TEXT);
    $result = $stmt->execute();
    $exists = $result->fetchArray();
    $db->close();
    
    if ($exists) {
        echo '<p>问题已存在，跳过生成</p>';
    } else {
        // 生成内容
        $questionok = $question.QUESTIONS_ADD;
        $answer = generateContent($questionok);
        if ($answer === false) {
            echo '<p style="color:red;">生成失败</p>';
        } else {
            // 保存到数据库
            if (saveToDatabase($question, $answer)) {
                echo '<p style="color:green;">生成成功</p>';
            } else {
                echo '<p style="color:red;">保存失败</p>';
            }
        }
    }
    
    // 处理下一个问题或完成
    $nextIndex = $currentIndex + 1;
    if ($nextIndex < count($questions)) {
        echo '<p>5秒后自动处理下一个问题...</p>';
        echo '<script>
            setTimeout(function() {
                window.location = "?action=generate&index='.$nextIndex.'";
            }, 5000);
        </script>';
        echo '<a href="?action=generate&index='.$nextIndex.'">立即处理下一个</a>';
    } else {
        echo '<p><strong>所有问题生成完成</strong></p>';
        echo '<a href="?action=list">查看内容列表</a>';
    }
}

// HTML模板
function SiteHeader($title = '', $keywords = '', $description = '') {
    // SEO设置
    $title = !empty($title) ? $title : 'AIGC内容生成管理系统';
    $keywords = !empty($keywords) ? $keywords : 'AIGC内容生成管理系统';
    $title = !empty($title) ? $title : 'AIGC内容生成管理系统';
    $description = !empty($description) ? $description : 'AIGC内容生成管理系统';
    
    echo <<<HTML
    <title>{$title}</title>
    <meta name="keywords" content="{$keywords}">
    <meta name="description" content="{$description}">
HTML;
}

// 主控制器
function handleRequest() {
    $action = isset($_GET['action']) ? $_GET['action'] : 'list';
    
    switch ($action) {
        case 'generate':
            generateNewContent();
            break;
        case 'view':
            if (isset($_GET['id'])) {
                if (isset($_GET['type'])) {
                    viewContent(intval($_GET['id']), null, 'raw');
                    exit;
                }
                viewContent(intval($_GET['id']));
            } else {
                displayContentList();
            }
            break;
        case 'edit':
            if (isset($_GET['id'])) {
                editContent(intval($_GET['id']));
            } else {
                displayContentList();
            }
            break;
        case 'update':
            if (isset($_POST['id']) && isset($_POST['question']) && isset($_POST['answer'])) {
                updateContent(
                    intval($_POST['id']),
                    trim($_POST['question']),
                    trim($_POST['answer'])
                );
            }
            break;
        case 'add':
            addQuestionForm();
            break;
        case 'save_question':
            if (isset($_POST['question'])) {
                saveQuestionAndGenerate(trim($_POST['question']));
            }
            break;
        case 'list':
        default:
            displayContentList();
            break;
    }
}

// 初始化并运行
initDatabase();
?>
<!DOCTYPE html>
<html>
<head>
    <?php if(@$_GET['action'] =='view'){
       #$parts = preg_split('/(，|,)/u', viewContent(intval($_GET['id']), '内容标题'), -1, PREG_SPLIT_DELIM_CAPTURE);
       #echo '<title>'.$parts[0].'</title>';
       echo '<title>'.viewContent(intval($_GET['id']), '内容标题').'</title>';
    }else{
       echo '<title>AIGC内容生成管理系统</title>';
    }
    ?>
    <link href="base.css?https://cdn.bootcdn.net/ajax/libs/picocss/2.1.0/pico.css#base.css?" rel="stylesheet">
    <style>
        /*body { font-family: Arial, sans-serif; margin: 20px; }*/
        .pagination { margin: 20px 0; }
        .pagination a, .pagination strong { 
            display: inline-block; 
            padding: 5px 10px; 
            margin: 0 2px; 
            border: 1px solid #ddd; 
            text-decoration: none;
        }
        .right-align {
            text-align: right;
        }
        .pagination a:hover { background: #eee; }
        .pagination strong { background: #0073aa; color: white; }
        .success { color: green; }
        .error { color: red; }
    </style>
</head>
<body>
<div class="container">
    <?php if(!@$_GET['action'] =='view'){ ?><h1>AIGC内容生成管理系统</h1>
    <div style="margin-bottom: 20px;">
        <a href="?action=list">内容列表</a> | 
        <a href="?action=add">添加问题</a> | 
        <a href="?action=generate">批量生成内容</a>
    </div><?php } ?>
    <?php #echo viewContent(intval($_GET['id']), '内容标题'); ?>
    <?php handleRequest(); ?>
    </div>
</body>
</html>