<?php
if (!empty($_GET['q'])) {
  switch ($_GET['q']) {
    case 'info':
      phpinfo();
      exit;
      break;
  }
}
$serverName = gethostname();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php print($serverName); ?></title>
  <style>
    *,
    :before *,
    :after * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      min-height: 100vh;
      font-weight: 100;
        font-family: 'Karla', sans-serif;
      font-size: 18px;
    }

    header,
    main,
    nav,
    aside {
      padding: 1rem;
      margin: auto;
      max-width: 1200px;
      text-align: center;
    }

    header {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
    }

    .header__item {
      margin: 0;
      padding: 1rem;
    }

    .header--logo {
      height: 8rem;
    }

    h1 {
      font-size: 5rem;
    }

    main {
      background-color: #f5f5f5;
    }

    nav {
      width: 100%;
    }

    ul {
      list-style: none;
      padding: 0;
      margin: auto;
    }

    a {
      color: #37ADFF;
      font-weight: 900;
      text-decoration: none;
    }

    a:hover {
      color: red;
      font-weight: 900;
      transition: 300ms;
    }

    main a {
      color: grey;
    }

    nav a {
      display: block;
      margin: 1rem 0;
    }

    nav a:after {
      content: '→';
      margin-left: 0.5rem;
    }

    .alert {
      color: red;
      font-weight: 900;
    }

    @media (min-width: 650px) {
      h1 {
        font-size: 10rem;
      }
    }
  </style>
</head>

<body>
  <header>
    <h1 class="header__item header--title" title="Server"><?php print($serverName); ?></h1>
  </header>
  <main>
    <p>
      <?php print(strtoupper($_SERVER['SERVER_SOFTWARE'])); ?>
    </p>
    <p>
      PHP version: <?php print PHP_VERSION; ?> <span><a title="phpinfo()" href="?q=info">info</a></span>
    </p>
    <p>
      Document Root: <?php print($_SERVER['DOCUMENT_ROOT']); ?>
    </p>
    <p>
      <a title="Getting Started" href="cgi-bin/luci/">Luci</a>
    </p>
  </main>
  <?php
  $dirList = glob('*', GLOB_ONLYDIR);
  //print_r($dirList);
  if (!empty($dirList)) :  
  ?>
    <nav>
      <ul>
        <?php
        foreach ($dirList as $key => $value) :
          $link = './' . $value . '/';
        ?>
          <a href="<?php echo $link; ?>" target="_blank"><?php echo $link; ?></a>
        <?php
        endforeach;
        ?>
      </ul>
    </nav>
  <?php
  else :
  ?>
    <aside>
      <p class="alert">创建您的第一个项目！</p>
    </aside>
  <?php
  endif;
  ?>
</body>

</html>