<?php
// 配置项
$config = [
    'site_name' => '优正体育',
    'site_slogan' => '优正体育',
    'banner_text' => '专业的塑胶篮球场厂家',
    'banner_image' => 'https://example.com/path/to/banner.jpg',
    'copyright_year' => date('Y'),
    'icp_number' => '京ICP备12345678号',
    'template_file' => 'template.html',
    'output_dir' => 'output/',
    'db_file' => 'content_ai.db'
];

// 确保输出目录存在
if (!file_exists($config['output_dir'])) {
    mkdir($config['output_dir'], 0755, true);
}

// 连接数据库
try {
    $db = new PDO('sqlite:' . $config['db_file']);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die('数据库连接失败: ' . $e->getMessage());
}
        
// 获取所有文章
$stmt = $db->query('SELECT * FROM generated_content ORDER BY created_at DESC');
$articles = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 如果没有文章则退出
if (empty($articles)) {
    die('没有找到任何文章');
}

// 读取模板
$template = file_get_contents($config['template_file']);
if ($template === false) {
    die('无法读取模板文件');
}
include_once 'Parsedown.class.php';
// 生成每篇文章的HTML
foreach ($articles as $index => $article) {
    // 准备替换数据
    
    $Parsedown = new Parsedown();
    $answer = $Parsedown->text($article['answer']);
    $answer = str_replace('[x]','<input type="checkbox" checked>',$answer);
    $answer = str_replace('[ ]','<input type="checkbox">',$answer);
    $lines = preg_split('/\r\n|\n|\r/', strip_tags($answer));

    // 过滤掉空行
    $nonEmptyLines = array_filter($lines, function($line) {
        return trim($line) !== '';
    });

    // 获取最后一行
    $search = ['总结来说，', '总结，', '总结：', '综上，', '综上所述，', '总结而言，'];
    $replace = ''; // 替换为空字符串（删除）
    $lastLine = str_replace($search, $replace, end($nonEmptyLines));#end($nonEmptyLines);
    $pattern = '/<p>[^<]*?(好的，这是一篇|分析文章：)[^<]*?<\/p>/';
    #$modifiedHtml = preg_replace($pattern, '', $html);
    require_once 'TextReplacer.php';
    $replacer = new TextReplacer('dictionary.txt');
    #$resultext = $replacer->replace($modified_content);
    $replacements = [
        '{title}' => htmlspecialchars($article['question']),
        '{keywords}' => htmlspecialchars($article['category_id'] ?? $config['site_name']),
        '{description}' => $lastLine,#end(strip_tags($answer)),#end(strip_tags($answer ?? mb_substr(strip_tags($answer), 0, 100) . '...'))
        '{content}' => $replacer->replace(preg_replace($pattern, '', preg_replace('/<\/?(strong|h2)(\s+[^>]*)?>/i', '', $answer))),#preg_replace($pattern, '', preg_replace('/<\/?strong>/i', '', $answer))
        '{created_at}' => date('Y-m-d H:i:s', strtotime($article['created_at'])),
        '{site_name}' => $config['site_name'],
        '{site_slogan}' => $config['site_slogan'],
        '{banner_text}' => $config['banner_text'],
        '{banner_image}' => $config['banner_image'],
        '{copyright_year}' => $config['copyright_year'],
        '{icp_number}' => $config['icp_number'],
    ];
    
    // 添加上一篇/下一篇链接
    $prev_article = '';
    $next_article = '';
    
    /*if ($index > 0) {
        $prev = $articles[$index - 1];
        $prev_article = '<a href="' . $prev['slug'] . '.html" class="nav-button">上一篇: ' . htmlspecialchars($prev['title']) . '</a>';
    }
    
    if ($index < count($articles) - 1) {
        $next = $articles[$index + 1];
        $next_article = '<a href="' . $next['slug'] . '.html" class="nav-button">下一篇: ' . htmlspecialchars($next['title']) . '</a>';
    }*/
    
    $replacements['{prev_article}'] = '上一篇';#$prev_article;
    $replacements['{next_article}'] = '下一篇';#//$next_article;
    
    // 替换模板中的占位符
    $html = $template;
    foreach ($replacements as $key => $value) {
        $html = str_replace($key, $value, $html);
    }
    
    // 写入文件
    include_once 'Pinyin.php';
    #$cn = isset($_GET['cn']) ? $_GET['cn'] : '你好';
    $pinyin = Pinyin::getPinyin($article['question']);
    $filename = $config['output_dir'] . $pinyin . '.html';
    if (file_put_contents($filename, $html) === false) {
        echo "无法写入文件: $filename\n";
    } else {
        echo "已生成: $filename\n";
    }
}

echo "HTML生成完成!\n";
?>